#include <amxmodx>
#include <umitem>
#include <fakemeta>
#include <engine>
#include <csx>

#define MAX_ENT			999
#define ACTIVATE_DISTANCE	190
#define EXPLODE_DELAY		0.5
#define GRENADE_VELOCITY	280.0
#define THROW_VELOCITY		90

new PLUGIN_NAME[] 	= "UM Item: Grenade Trap"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.0"

new PauseEnt[MAX_ENT+1]
new bool:GrenadeVelocity[MAX_ENT+1]
new Float:Delay[33]
new bool:g_TrapMode[33]
new bool:g_GrenadeTrap[33] 

public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Grenade Trap", "To activate trap mode hold a grenade and press your 'attack2' button", 2000)
	register_logevent("LogEvent_RoundStart", 2, "0=World triggered", "1=Round_Start")
	register_event("TextMsg", "Event_GameRestart", "a", "2=#Game_will_restart_in") 
	register_forward(FM_Think, "FW_Think")
	
	set_task(0.1, "Grenade_Think", _, _, _, "b")
}

public LogEvent_RoundStart() 
{
	for(new i = 1; i <= MAX_ENT; i++) 
	{ 
		PauseEnt[i] = 0
		GrenadeVelocity[i] = false
	}
}

public Event_GameRestart()
{
	new Float:fRestartCvar = get_cvar_float("sv_restart")
	set_task((fRestartCvar - 0.5), "LogEvent_RoundStart")
}

public client_connect(id) {
	g_GrenadeTrap[id] = false
}

public Enable_Item(id) {
	g_GrenadeTrap[id] = true
}

public Disable_Item(id) {
	g_GrenadeTrap[id] = false
}

public client_PreThink(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!g_GrenadeTrap[id]) {
		return PLUGIN_CONTINUE
	}

	new temp[2], weapon = get_user_weapon(id, temp[0], temp[1])
	if(weapon == CSW_HEGRENADE || weapon == CSW_FLASHBANG || weapon == CSW_SMOKEGRENADE)
	{
		if(get_user_button(id) & IN_ATTACK2)
		{
			if((Delay[id] + 1.0) < get_gametime())
			{
				if(!g_TrapMode[id]) 
				{
					client_print(id, print_chat, "Trap Mode [On]")
					g_TrapMode[id] = true
				} else {
					client_print(id, print_chat, "Trap Mode [Off]")
					g_TrapMode[id] = false
				}
				Delay[id] = get_gametime()
			}
		}
	} else {
		g_TrapMode[id] = false
	}
	return PLUGIN_CONTINUE
}

public grenade_throw(id, ent, wId)
{
	if(g_TrapMode[id]) 
	{
		new Float:Velocity[3]
		velocity_by_aim(id, THROW_VELOCITY, Velocity)
		entity_set_vector(ent, EV_VEC_velocity, Velocity)
		
		entity_set_edict(ent, EV_ENT_owner, id)
		g_TrapMode[id] = false

		new param[1]
		param[0] = ent
		set_task(1.2, "ActivateTrap", 0, param, 1)
	}
}

public ActivateTrap(param[]) 
{
	new ent = param[0]
	if(is_valid_ent(ent)) 
	{
		PauseEnt[ent] = 1
		new Float:vOrigin[3]
		entity_get_vector(ent, EV_VEC_origin, vOrigin)
		vOrigin[2] -= 7.0
		entity_set_vector(ent, EV_VEC_origin, vOrigin)
		entity_set_int(ent, EV_INT_movetype, MOVETYPE_TOSS)
		entity_set_int(ent, EV_INT_solid, SOLID_NOT)
	}
}

public Grenade_Think()
{
	new grenade = find_ent_by_class(-1, "grenade")
	while(grenade)
	{	
		new szModel[32]
		entity_get_string(grenade, EV_SZ_model, szModel, 31)
		if(equali(szModel, "models/w_hegrenade.mdl") || equali(szModel, "models/w_smokegrenade.mdl") 
		|| equali(szModel, "models/w_flashbang.mdl")) 
		{
			if(PauseEnt[grenade] > 0)
			{
				new Players[32], iNum
				get_players(Players, iNum, "a")
					
				for(new i = 0; i < iNum; ++i)
				{
					new id = Players[i]
					if(get_user_team(entity_get_edict(grenade, EV_ENT_owner)) != get_user_team(id))
					{
						if(get_entity_distance(id, grenade) <= ACTIVATE_DISTANCE)
						{
							new Float:vOrigin[3]
							entity_get_vector(grenade, EV_VEC_origin, vOrigin)
							while(PointContents(vOrigin) == CONTENTS_SOLID) {
								vOrigin[2] += 10.0
							}
							entity_set_vector(grenade, EV_VEC_origin, vOrigin)
							if(!GrenadeVelocity[grenade])
							{
								new Float:flVelocity[3]
								entity_get_vector(grenade, EV_VEC_velocity, flVelocity)
								flVelocity[2] += GRENADE_VELOCITY
								entity_set_vector(grenade, EV_VEC_velocity, flVelocity)
								GrenadeVelocity[grenade] = true
							}
					
							new param[1]
							param[0] = grenade
							set_task(EXPLODE_DELAY, "ExplodeNade", 0, param, 1)
						}
					}
				}
			}
		}
		grenade = find_ent_by_class(grenade, "grenade")
	}
	return PLUGIN_CONTINUE
}

public ExplodeNade(param[])
{
	new ent = param[0]
	if(is_valid_ent(ent)) 
	{
		PauseEnt[ent] = 0
		GrenadeVelocity[ent] = false
	}
}

public FW_Think(ent) 
{
	if(ent < 0 || ent > MAX_ENT) {
		return FMRES_IGNORED
	}

	if(PauseEnt[ent] > 0) 
	{
		new Float:flNextThink = entity_get_float(ent, EV_FL_nextthink)
		set_pev(ent, pev_nextthink, flNextThink + 0.1)
		return FMRES_SUPERCEDE
	}
	return FMRES_IGNORED
 }

/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
